/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.gprinter.command.LabelCommand;
import com.gprinter.utils.BitmapUtils;
import com.gprinter.utils.GpUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EscCommand {
    private static final String DEBUG_TAG = EscCommand.class.getSimpleName();
    Vector<Byte> Command = new Vector(4096, 1024);

    protected void addArrayToCommand(byte[] array) {
        for (byte b : array) {
            this.Command.add(b);
        }
    }

    private void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB18030");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (bs == null) {
                return;
            }
            for (byte b : bs) {
                this.Command.add(b);
            }
        }
    }

    private void addStrToCommand(String str, String charset) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (bs == null) {
                return;
            }
            for (byte b : bs) {
                this.Command.add(b);
            }
        }
    }

    private void addStrToCommandUTF8Encoding(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            if (Build.VERSION.SDK_INT >= 19) {
                bs = str.getBytes(StandardCharsets.UTF_8);
            }
            if (bs == null) {
                return;
            }
            for (byte b : bs) {
                this.Command.add(b);
            }
        }
    }

    private void addStrToCommand(String str, int length) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB18030");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (bs == null) {
                return;
            }
            if (length > bs.length) {
                length = bs.length;
            }
            for (int i = 0; i < length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void addHorTab() {
        byte[] command = new byte[]{9};
        this.addArrayToCommand(command);
    }

    public void addText(String text) {
        this.addStrToCommand(text);
    }

    public void addText(String text, String charsetName) {
        this.addStrToCommand(text, charsetName);
    }

    public void addArabicText(String text) {
        String[] fooInput;
        text = GpUtils.reverseLetterAndNumber(text);
        text = GpUtils.splitArabic(text);
        for (String in : fooInput = text.split("\\n")) {
            byte[] output;
            for (byte b : output = GpUtils.string2Cp864(in)) {
                if (b == -16) {
                    this.addArrayToCommand(new byte[]{27, 116, 29, -124, 27, 116, 22});
                    continue;
                }
                if (b == 127) {
                    this.Command.add((byte)-41);
                    continue;
                }
                this.Command.add(b);
            }
        }
    }

    public void addPrintAndLineFeed() {
        byte[] command = new byte[]{10};
        this.addArrayToCommand(command);
    }

    public void RealtimeStatusTransmission(STATUS status) {
        byte[] command = new byte[]{16, 4, 0};
        command[2] = status.getValue();
        this.addArrayToCommand(command);
    }

    public void addGeneratePluseAtRealtime(LabelCommand.FOOT foot, byte t) {
        byte[] command = new byte[]{16, 20, 1, 0, 0};
        command[3] = (byte)foot.getValue();
        if (t > 8) {
            t = (byte)8;
        }
        command[4] = t;
        this.addArrayToCommand(command);
    }

    public void addSound(byte n, byte t) {
        byte[] command = new byte[]{27, 66, 0, 0};
        if (n < 0) {
            n = 1;
        } else if (n > 9) {
            n = (byte)9;
        }
        if (t < 0) {
            t = 1;
        } else if (t > 9) {
            t = (byte)9;
        }
        command[2] = n;
        command[3] = t;
        this.addArrayToCommand(command);
    }

    public void addSetRightSideCharacterSpacing(byte n) {
        byte[] command = new byte[]{27, 32, 0};
        command[2] = n;
        this.addArrayToCommand(command);
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void addSelectPrintModes(FONT font, ENABLE emphasized, ENABLE doubleheight, ENABLE doublewidth, ENABLE underline) {
        int temp = 0;
        if (font == FONT.FONTB) {
            temp = 1;
        }
        if (emphasized == ENABLE.ON) {
            temp = (byte)(temp | 8);
        }
        if (doubleheight == ENABLE.ON) {
            temp = (byte)(temp | 0x10);
        }
        if (doublewidth == ENABLE.ON) {
            temp = (byte)(temp | 0x20);
        }
        if (underline == ENABLE.ON) {
            temp = (byte)(temp | 0x80);
        }
        byte[] command = new byte[]{27, 33, 0};
        command[2] = temp;
        this.addArrayToCommand(command);
    }

    public void addSetAbsolutePrintPosition(short n) {
        byte[] command = new byte[]{27, 36, 0, 0};
        byte nl = (byte)(n % 256);
        byte nh = (byte)(n / 256);
        command[2] = nl;
        command[3] = nh;
        this.addArrayToCommand(command);
    }

    public void addSelectOrCancelUserDefineCharacter(ENABLE enable) {
        byte[] command = new byte[]{27, 37, 0};
        if (enable == ENABLE.ON) {
            command[2] = 1;
        }
        this.addArrayToCommand(command);
    }

    public void addTurnUnderlineModeOnOrOff(UNDERLINE_MODE underline) {
        byte[] command = new byte[]{27, 45, 0};
        command[2] = underline.getValue();
        this.addArrayToCommand(command);
    }

    public void addSelectDefualtLineSpacing() {
        byte[] command = new byte[]{27, 50};
        this.addArrayToCommand(command);
    }

    public void addSetLineSpacing(byte n) {
        byte[] command = new byte[]{27, 51, 0};
        command[2] = n;
        this.addArrayToCommand(command);
    }

    public void addCancelUserDefinedCharacters(byte n) {
        byte[] command = new byte[]{27, 63, 0};
        command[2] = n >= 32 && n <= 126 ? n : (byte)32;
        this.addArrayToCommand(command);
    }

    public void addInitializePrinter() {
        this.addArrayToCommand(new byte[64]);
        byte[] command = new byte[]{27, 64};
        this.addArrayToCommand(command);
    }

    public void addTurnEmphasizedModeOnOrOff(ENABLE enabel) {
        byte[] command = new byte[]{27, 69, 0};
        command[2] = enabel.getValue();
        this.addArrayToCommand(command);
    }

    public void addTurnDoubleStrikeOnOrOff(ENABLE enabel) {
        byte[] command = new byte[]{27, 71, 0};
        command[2] = enabel.getValue();
        this.addArrayToCommand(command);
    }

    public void addPrintAndFeedPaper(byte n) {
        byte[] command = new byte[]{27, 74, 0};
        command[2] = n;
        this.addArrayToCommand(command);
    }

    public void addSelectCharacterFont(FONT font) {
        byte[] command = new byte[]{27, 77, 0};
        command[2] = font.getValue();
        this.addArrayToCommand(command);
    }

    public void addSelectInternationalCharacterSet(CHARACTER_SET set) {
        byte[] command = new byte[]{27, 82, 0};
        command[2] = set.getValue();
        this.addArrayToCommand(command);
    }

    public void addTurn90ClockWiseRotatin(ENABLE enabel) {
        byte[] command = new byte[]{27, 86, 0};
        command[2] = enabel.getValue();
        this.addArrayToCommand(command);
    }

    public void addSetRelativePrintPositon(short n) {
        byte[] command = new byte[]{27, 92, 0, 0};
        byte nl = (byte)(n % 256);
        byte nh = (byte)(n / 256);
        command[2] = nl;
        command[3] = nh;
        this.addArrayToCommand(command);
    }

    public void addSelectJustification(JUSTIFICATION just) {
        byte[] command = new byte[]{27, 97, 0};
        command[2] = just.getValue();
        this.addArrayToCommand(command);
    }

    public void addPrintAndFeedLines(byte n) {
        byte[] command = new byte[]{27, 100, 0};
        command[2] = n;
        this.addArrayToCommand(command);
    }

    public void addGeneratePlus(LabelCommand.FOOT foot, byte t1, byte t2) {
        byte[] command = new byte[]{27, 112, 0, 0, 0};
        command[2] = (byte)foot.getValue();
        command[3] = t1;
        command[4] = t2;
        this.addArrayToCommand(command);
    }

    public void addSelectCodePage(CODEPAGE page) {
        byte[] command = new byte[]{27, 116, 0};
        command[2] = page.getValue();
        this.addArrayToCommand(command);
    }

    public void addTurnUpsideDownModeOnOrOff(ENABLE enable) {
        byte[] command = new byte[]{27, 123, 0};
        command[2] = enable.getValue();
        this.addArrayToCommand(command);
    }

    public void addSetCharcterSize(WIDTH_ZOOM width, HEIGHT_ZOOM height) {
        byte[] command = new byte[]{29, 33, 0};
        byte temp = 0;
        temp = (byte)(temp | width.getValue());
        command[2] = temp = (byte)(temp | height.getValue());
        this.addArrayToCommand(command);
    }

    public void addTurnReverseModeOnOrOff(ENABLE enable) {
        byte[] command = new byte[]{29, 66, 0};
        command[2] = enable.getValue();
        this.addArrayToCommand(command);
    }

    public void addSelectPrintingPositionForHRICharacters(HRI_POSITION position) {
        byte[] command = new byte[]{29, 72, 0};
        command[2] = position.getValue();
        this.addArrayToCommand(command);
    }

    public void addSetLeftMargin(short n) {
        byte[] command = new byte[]{29, 76, 0, 0};
        byte nl = (byte)(n % 256);
        byte nh = (byte)(n / 256);
        command[2] = nl;
        command[3] = nh;
        this.addArrayToCommand(command);
    }

    public void addSetHorAndVerMotionUnits(byte x, byte y) {
        byte[] command = new byte[]{29, 80, 0, 0};
        command[2] = x;
        command[3] = y;
        this.addArrayToCommand(command);
    }

    public void addCutAndFeedPaper(byte length) {
        byte[] command = new byte[]{29, 86, 66, 0};
        command[3] = length;
        this.addArrayToCommand(command);
    }

    public void addCutPaper() {
        byte[] command = new byte[]{29, 86, 1};
        this.addArrayToCommand(command);
    }

    public void addSetPrintingAreaWidth(short width) {
        byte nl = (byte)(width % 256);
        byte nh = (byte)(width / 256);
        byte[] command = new byte[]{29, 87, 0, 0};
        command[2] = nl;
        command[3] = nh;
        this.addArrayToCommand(command);
    }

    public void addSetAutoSatusBack(ENABLE enable) {
        byte[] command = new byte[]{29, 97, 0};
        if (enable == ENABLE.ON) {
            command[2] = -1;
        }
        this.addArrayToCommand(command);
    }

    public void addSetFontForHRICharacter(FONT font) {
        byte[] command = new byte[]{29, 102, 0};
        command[2] = font.getValue();
        this.addArrayToCommand(command);
    }

    public void addSetBarcodeHeight(byte height) {
        byte[] command = new byte[]{29, 104, 0};
        command[2] = height;
        this.addArrayToCommand(command);
    }

    public void addSetBarcodeWidth(byte width) {
        byte[] command = new byte[]{29, 119, 0};
        if (width > 6) {
            width = (byte)6;
        }
        if (width < 2) {
            width = 1;
        }
        command[2] = width;
        this.addArrayToCommand(command);
    }

    public void addSetKanjiFontMode(ENABLE DoubleWidth, ENABLE DoubleHeight, ENABLE Underline) {
        byte[] command = new byte[]{28, 33, 0};
        int temp = 0;
        if (DoubleWidth == ENABLE.ON) {
            temp = (byte)(temp | 4);
        }
        if (DoubleHeight == ENABLE.ON) {
            temp = (byte)(temp | 8);
        }
        if (Underline == ENABLE.ON) {
            temp = (byte)(temp | 0x80);
        }
        command[2] = temp;
        this.addArrayToCommand(command);
    }

    public void addSelectKanjiMode() {
        byte[] command = new byte[]{28, 38};
        this.addArrayToCommand(command);
    }

    public void addSetKanjiUnderLine(UNDERLINE_MODE underline) {
        byte[] command = new byte[]{28, 45, 0};
        command[2] = underline.getValue();
        this.addArrayToCommand(command);
    }

    public void addCancelKanjiMode() {
        byte[] command = new byte[]{28, 46};
        this.addArrayToCommand(command);
    }

    public void addSetKanjiLefttandRightSpace(byte left, byte right) {
        byte[] command = new byte[]{28, 83, 0, 0};
        command[2] = left;
        command[3] = right;
        this.addArrayToCommand(command);
    }

    public void addSetQuadrupleModeForKanji(ENABLE enable) {
        byte[] command = new byte[]{28, 87, 0};
        command[2] = enable.getValue();
        this.addArrayToCommand(command);
    }

    public void addRastBitImage(Bitmap bitmap, int nWidth, int nMode) {
        if (bitmap != null) {
            byte[] codecontent;
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = GpUtils.toGrayscale(bitmap);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            byte[] command = new byte[8];
            height = src.length / width;
            command[0] = 29;
            command[1] = 118;
            command[2] = 48;
            command[3] = (byte)(nMode & 1);
            command[4] = (byte)(width / 8 % 256);
            command[5] = (byte)(width / 8 / 256);
            command[6] = (byte)(height % 256);
            command[7] = (byte)(height / 256);
            this.addArrayToCommand(command);
            for (byte b : codecontent = GpUtils.pixToEscRastBitImageCmd(src)) {
                this.Command.add(b);
            }
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
    }

    public void drawImage(Bitmap bitmap) {
        int bmpWidth = bitmap.getWidth() % 8;
        int width1 = bmpWidth == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int bmpHeight = bitmap.getHeight();
        byte[] printImage = BitmapUtils.getCompressedBinaryzationBytes(bitmap, 128, true);
        byte[] LData = new byte[printImage.length + 8];
        LData[0] = 29;
        LData[1] = 118;
        LData[2] = 48;
        LData[3] = 0;
        LData[4] = (byte)(width1 % 256);
        LData[5] = (byte)(width1 / 256);
        LData[6] = (byte)(bmpHeight % 256);
        LData[7] = (byte)(bmpHeight / 256);
        System.arraycopy(printImage, 0, LData, 8, printImage.length);
        for (byte lDatum : LData) {
            this.Command.add(lDatum);
        }
    }

    public void drawImage(Bitmap img, int nWidth) {
        if (img == null) {
            return;
        }
        int width = (nWidth + 7) / 8 * 8;
        int height = img.getHeight() * width / img.getWidth();
        Bitmap bitmap = BitmapUtils.resizeImage(img, width, height);
        int bmpWidth = bitmap.getWidth() % 8;
        int width1 = bmpWidth == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int bmpHeight = bitmap.getHeight();
        byte[] printImage = BitmapUtils.getCompressedBinaryzationBytes(bitmap, true);
        byte[] LData = new byte[printImage.length + 8];
        LData[0] = 29;
        LData[1] = 118;
        LData[2] = 48;
        LData[3] = 0;
        LData[4] = (byte)(width1 % 256);
        LData[5] = (byte)(width1 / 256);
        LData[6] = (byte)(bmpHeight % 256);
        LData[7] = (byte)(bmpHeight / 256);
        System.arraycopy(printImage, 0, LData, 8, printImage.length);
        for (byte lDatum : LData) {
            this.Command.add(lDatum);
        }
    }

    public void drawJpgImage(Bitmap img, int nWidth) {
        if (img == null) {
            return;
        }
        int width = (nWidth + 7) / 8 * 8;
        int height = img.getHeight() * width / img.getWidth();
        Bitmap bitmap = BitmapUtils.threshold(BitmapUtils.resizeImage(img, width, height), true);
        int bmpWidth = bitmap.getWidth() % 8;
        int width1 = bmpWidth == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        int bmpHeight = bitmap.getHeight();
        byte[] printImage = BitmapUtils.getCompressedBinaryzationBytes(bitmap, true);
        byte[] LData = new byte[printImage.length + 8];
        LData[0] = 29;
        LData[1] = 118;
        LData[2] = 48;
        LData[3] = 0;
        LData[4] = (byte)(width1 % 256);
        LData[5] = (byte)(width1 / 256);
        LData[6] = (byte)(bmpHeight % 256);
        LData[7] = (byte)(bmpHeight / 256);
        System.arraycopy(printImage, 0, LData, 8, printImage.length);
        for (byte lDatum : LData) {
            this.Command.add(lDatum);
        }
    }

    public static byte[] pic2PxPoint(Bitmap bitmap, int mode, int printWidth) {
        int width = (printWidth + 7) / 8 * 8;
        int height = bitmap.getHeight() * width / bitmap.getWidth();
        Bitmap bit = BitmapUtils.resizeImage(bitmap, width, height);
        int cmdHead = bit.getHeight() / 8 * 5;
        int pixNum = bit.getHeight() / 8 * 3 * bit.getWidth();
        byte[] data = new byte[pixNum + cmdHead];
        int k = 0;
        for (int i = 0; i < bit.getHeight() / 24; ++i) {
            data[k++] = 27;
            data[k++] = 42;
            data[k++] = (byte)mode;
            data[k++] = (byte)(bit.getWidth() % 256);
            data[k++] = (byte)(bit.getWidth() / 256);
            for (int x = 0; x < bit.getWidth(); ++x) {
                for (int m = 0; m < 3; ++m) {
                    byte[] by = new byte[8];
                    for (int n = 0; n < 8; ++n) {
                        byte b;
                        by[n] = b = EscCommand.px2Byte(x, i * 24 + m * 8 + 7 - n, bit);
                    }
                    data[k] = (byte)EscCommand.changePointPx1(by);
                    ++k;
                }
            }
            data[k++] = 10;
        }
        return data;
    }

    public static byte[] pic8PxPoint(Bitmap bitmap, int mode, int printWidth) {
        int width = (printWidth + 7) / 8 * 8;
        int height = bitmap.getHeight() * width / bitmap.getWidth();
        Bitmap bit = BitmapUtils.resizeImage(bitmap, width, height);
        int cmdHead = bit.getHeight() / 8 * 7;
        int pixNum = bit.getHeight() / 8 * 3 * bit.getWidth();
        byte[] data = new byte[pixNum + cmdHead];
        int k = 0;
        for (int i = 0; i < bit.getHeight() / 8; ++i) {
            data[k++] = 27;
            data[k++] = 42;
            data[k++] = (byte)mode;
            data[k++] = (byte)(bit.getWidth() % 256);
            data[k++] = (byte)(bit.getWidth() / 256);
            for (int x = 0; x < bit.getWidth(); ++x) {
                byte[] by = new byte[8];
                for (int n = 0; n < 8; ++n) {
                    byte b;
                    by[n] = b = EscCommand.px2Byte(x, i * 8 + 7 - n, bit);
                }
                data[k] = (byte)EscCommand.changePointPx1(by);
                ++k;
            }
            data[k++] = 27;
            data[k++] = 74;
            data[k++] = 15;
        }
        return data;
    }

    public static byte px2Byte(int x, int y, Bitmap bit) {
        int blue;
        int green;
        int pixel = bit.getPixel(x, y);
        int red = (pixel & 0xFF0000) >> 16;
        int gray = EscCommand.RGB2Gray(red, green = (pixel & 0xFF00) >> 8, blue = pixel & 0xFF);
        byte b = gray < 128 ? (byte)1 : 0;
        return b;
    }

    public static int changePointPx1(byte[] arry) {
        int v = 0;
        for (int j = 0; j < arry.length; ++j) {
            if (arry[j] != 1) continue;
            v |= 1 << j;
        }
        return v;
    }

    private static int RGB2Gray(int r, int g, int b) {
        int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return gray;
    }

    public void addOriginRastBitImage(Bitmap bitmap, int nWidth, int nMode) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap rszBitmap = GpUtils.resizeImage(bitmap, width, height);
            this.addArrayToCommand(GpUtils.printEscDraw(rszBitmap));
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
    }

    public void addRastBitImageWithMethod(Bitmap bitmap, int nWidth, int nMode, int method) {
        if (bitmap != null) {
            byte[] codecontent;
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap resizeImage = GpUtils.resizeImage(bitmap, width, height);
            Bitmap rszBitmap = GpUtils.filter(resizeImage, resizeImage.getWidth(), resizeImage.getHeight());
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            byte[] command = new byte[8];
            height = src.length / width;
            command[0] = 29;
            command[1] = 118;
            command[2] = 48;
            command[3] = (byte)(nMode & 1);
            command[4] = (byte)(width / 8 % 256);
            command[5] = (byte)(width / 8 / 256);
            command[6] = (byte)(height % 256);
            command[7] = (byte)(height / 256);
            this.addArrayToCommand(command);
            for (byte b : codecontent = GpUtils.pixToEscRastBitImageCmd(src)) {
                this.Command.add(b);
            }
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
    }

    public void addDownloadNvBitImage(Bitmap[] bitmap) {
        if (bitmap != null) {
            Log.d((String)"BMP", (String)("bitmap.length " + bitmap.length));
            int n = bitmap.length;
            if (n > 0) {
                byte[] command = new byte[]{28, 113, (byte)n};
                this.addArrayToCommand(command);
                for (Bitmap value : bitmap) {
                    byte[] codecontent;
                    int height = (value.getHeight() + 7) / 8 * 8;
                    int width = value.getWidth() * height / value.getHeight();
                    Bitmap grayBitmap = GpUtils.toGrayscale(value);
                    byte[] src = GpUtils.bitmapToBWPix2(grayBitmap);
                    height = src.length / width;
                    for (byte b : codecontent = GpUtils.pixToEscNvBitImageCmd(src, width, height)) {
                        this.Command.add(b);
                    }
                }
            }
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
    }

    public void addPrintNvBitmap(byte n, byte mode) {
        byte[] command = new byte[]{28, 112, 0, 0};
        command[2] = n;
        command[3] = mode;
        this.addArrayToCommand(command);
    }

    public void addUPCA(String content) {
        byte[] command = new byte[]{29, 107, 65, 11};
        if (content.length() < command[3]) {
            return;
        }
        this.addArrayToCommand(command);
        this.addStrToCommand(content, 11);
    }

    public void addUPCE(String content) {
        byte[] command = new byte[]{29, 107, 66, 11};
        if (content.length() < command[3]) {
            return;
        }
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public void addEAN13(String content) {
        byte[] command = new byte[]{29, 107, 67, 12};
        if (content.length() < command[3]) {
            return;
        }
        this.addArrayToCommand(command);
        Log.d((String)DEBUG_TAG, (String)("content.length" + content.length()));
        this.addStrToCommand(content, command[3]);
    }

    public void addEAN8(String content) {
        byte[] command = new byte[]{29, 107, 68, 7};
        if (content.length() < command[3]) {
            return;
        }
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    @SuppressLint(value={"DefaultLocale"})
    public void addCODE39(String content) {
        byte[] command = new byte[]{29, 107, 69, (byte)content.length()};
        content = content.toUpperCase();
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public void addITF(String content) {
        byte[] command = new byte[]{29, 107, 70, (byte)content.length()};
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public void addCODABAR(String content) {
        byte[] command = new byte[]{29, 107, 71, (byte)content.length()};
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public void addCODE93(String content) {
        byte[] command = new byte[]{29, 107, 72, (byte)content.length()};
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public void addCODE128(String content) {
        byte[] command = new byte[]{29, 107, 73, (byte)content.length()};
        this.addArrayToCommand(command);
        this.addStrToCommand(content, command[3]);
    }

    public String genCodeC(String content) {
        ArrayList<Byte> bytes = new ArrayList<Byte>(20);
        int len = content.length();
        bytes.add((byte)123);
        bytes.add((byte)67);
        for (int i = 0; i < len; i += 2) {
            int ken = (content.charAt(i) - 48) * 10;
            int bits = content.charAt(i + 1) - 48;
            int current = ken + bits;
            bytes.add((byte)current);
        }
        byte[] bb = new byte[bytes.size()];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = (Byte)bytes.get(i);
        }
        return new String(bb, 0, bb.length);
    }

    public String genCodeB(String content) {
        return String.format("{B%s", content);
    }

    public String genCode128(String content) {
        String regex = "([^0-9])";
        String[] str = content.split(regex);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        String splitString = null;
        int strlen = str.length;
        if (strlen > 0 && matcher.find()) {
            splitString = matcher.group(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strlen; ++i) {
            String first = str[i];
            int len = first.length();
            int result = len % 2;
            if (result == 0) {
                String codeC = this.genCodeC(first);
                sb.append(codeC);
            } else {
                sb.append(this.genCodeB(String.valueOf(first.charAt(0))));
                sb.append(this.genCodeC(first.substring(1)));
            }
            if (splitString == null) continue;
            sb.append(this.genCodeB(splitString));
            splitString = null;
        }
        return sb.toString();
    }

    public void addSelectSizeOfModuleForQRCode(byte n) {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 49, 67, 3};
        command[7] = n;
        this.addArrayToCommand(command);
    }

    public void addSelectErrorCorrectionLevelForQRCode(byte n) {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 49, 69, 0};
        command[7] = n;
        this.addArrayToCommand(command);
    }

    public void addStoreQRCodeData(String content) {
        byte[] command = new byte[]{29, 40, 107, 0, 0, 49, 80, 48};
        command[3] = (byte)((content.getBytes().length + 3) % 256);
        command[4] = (byte)((content.getBytes().length + 3) / 256);
        this.addArrayToCommand(command);
        byte[] bs = null;
        if (!content.equals("")) {
            if (Build.VERSION.SDK_INT >= 19) {
                bs = content.getBytes(StandardCharsets.UTF_8);
            }
            if (bs == null) {
                return;
            }
            for (byte b : bs) {
                this.Command.add(b);
            }
        }
    }

    public void addPrintQRCode() {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 49, 81, 48};
        this.addArrayToCommand(command);
    }

    public void addSelectMaxiCodeMode(byte n) {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 50, 65, n};
        this.addArrayToCommand(command);
    }

    public void addStoreMaxiCodeData(String content) {
        byte[] command = new byte[]{29, 40, 107, 0, 0, 50, 80, 48};
        command[3] = (byte)((content.getBytes().length + 3) % 256);
        command[4] = (byte)((content.getBytes().length + 3) / 256);
        this.addArrayToCommand(command);
        byte[] bs = null;
        if (!content.equals("")) {
            if (Build.VERSION.SDK_INT >= 19) {
                bs = content.getBytes(StandardCharsets.UTF_8);
            }
            if (bs == null) {
                return;
            }
            for (byte b : bs) {
                this.Command.add(b);
            }
        }
    }

    public void addPrintMaxiCode() {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 50, 81, 48};
        this.addArrayToCommand(command);
    }

    public void addQueryPrinterStatus() {
        byte[] command = new byte[]{16, 4, 2};
        this.addArrayToCommand(command);
    }

    public void addUserCommand(byte[] command) {
        this.addArrayToCommand(command);
    }

    public void addUserCommand(String command) {
        this.addStrToCommand(command);
    }

    public void addEnableDoubleColorMode() {
        byte[] command = new byte[]{31, 27, 31, 98, 5, 1};
        this.addArrayToCommand(command);
    }

    public void setColor(boolean n) {
        byte[] command = new byte[]{27, 114, n ? (byte)1 : 0};
        this.addArrayToCommand(command);
    }

    public void addSetRedDensity(byte n) {
        byte[] command = new byte[]{31, 27, 31, 98, 7, 1, n};
        this.addArrayToCommand(command);
    }

    public void addSetBlackDensity(byte n) {
        byte[] command = new byte[]{31, 27, 31, 98, 7, 0, n};
        this.addArrayToCommand(command);
    }

    public void addDisableDoubleColorMode() {
        byte[] command = new byte[]{31, 27, 31, 98, 5, 0};
        this.addArrayToCommand(command);
    }

    public static enum HRI_POSITION {
        NO_PRINT(0),
        ABOVE(1),
        BELOW(2),
        ABOVE_AND_BELOW(3);

        private final int value;

        private HRI_POSITION(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum HEIGHT_ZOOM {
        MUL_1(0),
        MUL_2(1),
        MUL_3(2),
        MUL_4(3),
        MUL_5(4),
        MUL_6(5),
        MUL_7(6),
        MUL_8(7);

        private final int value;

        private HEIGHT_ZOOM(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum WIDTH_ZOOM {
        MUL_1(0),
        MUL_2(16),
        MUL_3(32),
        MUL_4(48),
        MUL_5(64),
        MUL_6(80),
        MUL_7(96),
        MUL_8(112);

        private final int value;

        private WIDTH_ZOOM(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum CODEPAGE {
        PC437(0),
        KATAKANA(1),
        PC850(2),
        PC860(3),
        PC863(4),
        PC865(5),
        WEST_EUROPE(6),
        GREEK(7),
        HEBREW(8),
        EAST_EUROPE(9),
        IRAN(10),
        WPC1252(16),
        PC866(17),
        PC852(18),
        PC858(19),
        IRANII(20),
        LATVIAN(21),
        ARABIC(22),
        PT151(23),
        PC747(24),
        WPC1257(25),
        VIETNAM(27),
        PC864(28),
        PC1001(29),
        UYGUR(30),
        THAI(255);

        private final int value;

        private CODEPAGE(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum MaxiCodeMode {
        mode_2(50),
        mode_3(51),
        mode_4(52),
        mode_5(53),
        mode_6(54);

        private final int value;

        private MaxiCodeMode(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum JUSTIFICATION {
        LEFT(0),
        CENTER(1),
        RIGHT(2);

        private final int value;

        private JUSTIFICATION(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum CHARACTER_SET {
        USA(0),
        FRANCE(1),
        GERMANY(2),
        UK(3),
        DENMARK_I(4),
        SWEDEN(5),
        ITALY(6),
        SPAIN_I(7),
        JAPAN(8),
        NORWAY(9),
        DENMARK_II(10),
        SPAIN_II(11),
        LATIN_AMERCIA(12),
        KOREAN(13),
        SLOVENIA(14),
        CHINA(15);

        private final int value;

        private CHARACTER_SET(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum FONT {
        FONTA(0),
        FONTB(1);

        private final int value;

        private FONT(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum UNDERLINE_MODE {
        OFF(0),
        UNDERLINE_1DOT(1),
        UNDERLINE_2DOT(2);

        private final int value;

        private UNDERLINE_MODE(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum ENABLE {
        OFF(0),
        ON(1);

        private final int value;

        private ENABLE(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }

    public static enum STATUS {
        PRINTER_STATUS(1),
        PRINTER_OFFLINE(2),
        PRINTER_ERROR(3),
        PRINTER_PAPER(4);

        private final int value;

        private STATUS(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }
}

